(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20573,        582]*)
(*NotebookOutlinePosition[     21412,        609]*)
(*  CellTagsIndexPosition[     21368,        605]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\( (*\ Example\ 2.5  .1\ *) \n (*\ with\ x1 = \(s1 = 1/6\), \ 
      x2 = \(s2 = 1/3\), \ x3 = \(s3 = 1/2\), \ x4 = \(s4 = 2/3\), \ 
      x5 = \(s5 = 5/6\)\ *) \)\)], "Input"],

Cell[BoxData[
    \(k[x_, s_] := \ 
      Which[x <= \ s, \ x \((1 - s)\), \ x >= s, \ s \((x - 1)\)]; \n
    k2[x_, s_] := \ 
      Which[x\  <= \ s, \ x*\((1 - s)\)*\((2\ s - x^2 - s^2)\)/6, \n\t\t
        x >= \ s, \ s*\((1 - x)\)*\((2\ x - x^2 - s^2)\)/6]; \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(denom = {\n
        \t{k[1/6, 1/6] - \ 216*x*k2[1/6, \ 1/6], \n\t\t\t
          k[1/6, 1/3] - \ 216*x*k2[1/6, \ 1/3], \n\t\t\t
          k[1/6, 1/2] - \ 216*x*k2[1/6, \ 1/2], \n\t\t\t
          k[1/6, 2/3] - \ 216*x*k2[1/6, \ 2/3], \n\t\t\t
          k[1/6, 5/6] - \ 216*x*k2[1/6, \ 5/6]}, \n
        \t{k[1/3, 1/6] - \ 216*x*k2[1/3, \ 1/6], \n\t\t\t
          k[1/3, 1/3] - \ 216*x*k2[1/3, \ 1/3], \n\t\t\t
          k[1/3, 1/2] - \ 216*x*k2[1/3, \ 1/2], \n\t\t\t
          k[1/3, 2/3] - \ 216*x*k2[1/3, \ 2/3], \n\t\t\t
          k[1/3, 5/6] - \ 216*x*k2[1/3, \ 5/6]}, \n
        \t\t{k[1/2, 1/6] - \ 216*x*k2[1/2, \ 1/6], \n\t\t\t
          k[1/2, 1/3] - \ 216*x*k2[1/2, \ 1/3], \n\t\t\t
          k[1/2, 1/2] - \ 216*x*k2[1/2, \ 1/2], \n\t\t\t
          k[1/2, 2/3] - \ 216*x*k2[1/2, \ 2/3], \n\t\t\t
          k[1/2, 5/6] - \ 216*x*k2[1/2, \ 5/6]}, \n
        \t\t{k[2/3, 1/6] - \ 216*x*k2[2/3, \ 1/6], \n\t\t\t
          k[2/3, 1/3] - \ 216*x*k2[2/3, \ 1/3], \n\t\t\t
          k[2/3, 1/2] - \ 216*x*k2[2/3, \ 1/2], \n\t\t\t
          k[2/3, 2/3] - \ 216*x*k2[2/3, \ 2/3], \n\t\t\t
          k[2/3, 5/6] - \ 216*x*k2[2/3, \ 5/6]}, \t\n
        \t\t\t{k[5/6, 1/6] - \ 216*x*k2[5/6, \ 1/6], \n\t\t\t
          k[5/6, 1/3] - \ 216*x*k2[5/6, \ 1/3], \n\t\t\t
          k[5/6, 1/2] - \ 216*x*k2[5/6, \ 1/2], \n\t\t\t
          k[5/6, 2/3] - \ 216*x*k2[5/6, \ 2/3], \n\t\t\t
          k[5/6, 5/6] - \ 216*x*k2[5/6, \ 5/6]}\ \ }\)], "Input"],

Cell[BoxData[
    \({{5\/36 - \(25\ x\)\/18, 1\/9 - \(19\ x\)\/9, 1\/12 - \(13\ x\)\/6, 
        1\/18 - \(31\ x\)\/18, 1\/36 - \(17\ x\)\/18}, {
        \(-\(1\/9\)\) - \(19\ x\)\/9, 2\/9 - \(32\ x\)\/9, 
        1\/6 - \(23\ x\)\/6, 1\/9 - \(28\ x\)\/9, 1\/18 - \(31\ x\)\/18}, {
        \(-\(1\/12\)\) - \(13\ x\)\/6, \(-\(1\/6\)\) - \(23\ x\)\/6, 
        1\/4 - \(9\ x\)\/2, 1\/6 - \(23\ x\)\/6, 1\/12 - \(13\ x\)\/6}, {
        \(-\(1\/18\)\) - \(31\ x\)\/18, \(-\(1\/9\)\) - \(28\ x\)\/9, 
        \(-\(1\/6\)\) - \(23\ x\)\/6, 2\/9 - \(32\ x\)\/9, 
        1\/9 - \(19\ x\)\/9}, {\(-\(1\/36\)\) - \(17\ x\)\/18, 
        \(-\(1\/18\)\) - \(31\ x\)\/18, \(-\(1\/12\)\) - \(13\ x\)\/6, 
        \(-\(1\/9\)\) - \(19\ x\)\/9, 5\/36 - \(25\ x\)\/18}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[%]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(5\/36 - \(25\ x\)\/18\), \(1\/9 - \(19\ x\)\/9\), 
              \(1\/12 - \(13\ x\)\/6\), \(1\/18 - \(31\ x\)\/18\), 
              \(1\/36 - \(17\ x\)\/18\)},
            {\(\(-\(1\/9\)\) - \(19\ x\)\/9\), \(2\/9 - \(32\ x\)\/9\), 
              \(1\/6 - \(23\ x\)\/6\), \(1\/9 - \(28\ x\)\/9\), 
              \(1\/18 - \(31\ x\)\/18\)},
            {\(\(-\(1\/12\)\) - \(13\ x\)\/6\), 
              \(\(-\(1\/6\)\) - \(23\ x\)\/6\), \(1\/4 - \(9\ x\)\/2\), 
              \(1\/6 - \(23\ x\)\/6\), \(1\/12 - \(13\ x\)\/6\)},
            {\(\(-\(1\/18\)\) - \(31\ x\)\/18\), 
              \(\(-\(1\/9\)\) - \(28\ x\)\/9\), 
              \(\(-\(1\/6\)\) - \(23\ x\)\/6\), \(2\/9 - \(32\ x\)\/9\), 
              \(1\/9 - \(19\ x\)\/9\)},
            {\(\(-\(1\/36\)\) - \(17\ x\)\/18\), 
              \(\(-\(1\/18\)\) - \(31\ x\)\/18\), 
              \(\(-\(1\/12\)\) - \(13\ x\)\/6\), 
              \(\(-\(1\/9\)\) - \(19\ x\)\/9\), \(5\/36 - \(25\ x\)\/18\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      This\ simplifies\ to\ m\ given\ below . \n\t\t\tNote\ we\ are\ writing\ 
        denom\ as\ m\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(m = {
        \ {5 \((1 - 10\ x)\), \ 4 \((1 - 19\ x)\), \ 3 \((1 - 26\ x)\), \ 
          2 \((1 - 31\ x)\), \ 1 - 34\ x}, \n
        \t\t{4 \((1 - 19\ x)\), \ 8 \((1 - 16\ x)\), \ 6 \((1 - 23\ x)\), \ 
          4 \((1 - 28\ x)\), \ 2 \((1 - 31\ x)\)}, \n
        \t\t{3 \((1 - 26\ x)\), \ 6 \((1 - 23\ x)\), \ 9 \((1 - 18\ x)\), \ 
          6 \((1 - 23\ x)\), \ 3 \((1 - 26\ x)\)}, \n
        \t\t{2 \((1 - 31\ x)\), \ 4 \((1 - 28\ x)\), \ 6 \((1 - 23\ x)\), \ 
          8 \((1 - 16\ x)\), \ 4 \((1 - 19\ x)\)}, \n
        \t\t{1 - 34\ x, \ 2 \((1 - 31\ x)\), \ 3 \((1 - 26\ x)\), \ 
          4 \((1 - 19\ x)\), \ 5 \((1 - 10\ x)\)}}\)], "Input"],

Cell[BoxData[
    \({{5\ \((1 - 10\ x)\), 4\ \((1 - 19\ x)\), 3\ \((1 - 26\ x)\), 
        2\ \((1 - 31\ x)\), 1 - 34\ x}, {4\ \((1 - 19\ x)\), 
        8\ \((1 - 16\ x)\), 6\ \((1 - 23\ x)\), 4\ \((1 - 28\ x)\), 
        2\ \((1 - 31\ x)\)}, {3\ \((1 - 26\ x)\), 6\ \((1 - 23\ x)\), 
        9\ \((1 - 18\ x)\), 6\ \((1 - 23\ x)\), 3\ \((1 - 26\ x)\)}, {
        2\ \((1 - 31\ x)\), 4\ \((1 - 28\ x)\), 6\ \((1 - 23\ x)\), 
        8\ \((1 - 16\ x)\), 4\ \((1 - 19\ x)\)}, {1 - 34\ x, 
        2\ \((1 - 31\ x)\), 3\ \((1 - 26\ x)\), 4\ \((1 - 19\ x)\), 
        5\ \((1 - 10\ x)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[%]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(5\ \((1 - 10\ x)\)\), \(4\ \((1 - 19\ x)\)\), 
              \(3\ \((1 - 26\ x)\)\), \(2\ \((1 - 31\ x)\)\), \(1 - 34\ x\)},
            {\(4\ \((1 - 19\ x)\)\), \(8\ \((1 - 16\ x)\)\), 
              \(6\ \((1 - 23\ x)\)\), \(4\ \((1 - 28\ x)\)\), 
              \(2\ \((1 - 31\ x)\)\)},
            {\(3\ \((1 - 26\ x)\)\), \(6\ \((1 - 23\ x)\)\), 
              \(9\ \((1 - 18\ x)\)\), \(6\ \((1 - 23\ x)\)\), 
              \(3\ \((1 - 26\ x)\)\)},
            {\(2\ \((1 - 31\ x)\)\), \(4\ \((1 - 28\ x)\)\), 
              \(6\ \((1 - 23\ x)\)\), \(8\ \((1 - 16\ x)\)\), 
              \(4\ \((1 - 19\ x)\)\)},
            {\(1 - 34\ x\), \(2\ \((1 - 31\ x)\)\), \(3\ \((1 - 26\ x)\)\), 
              \(4\ \((1 - 19\ x)\)\), \(5\ \((1 - 10\ x)\)\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[Det[m] == 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0467457811220566288`}, {
        x \[Rule] 0.199999999999999928`}, {x \[Rule] 0.500000000000000888`}, {
        x \[Rule] 0.999999999999998046`}, {x \[Rule] 1.64556191118563681`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Now\ the\ eigenvalues\ *) \n
    \[Lambda]1 = 216*0.0467457811220566288`\)\)], "Input"],

Cell[BoxData[
    \(10.0970887223642313`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]2 = 216*0.199999999999999928`\)], "Input"],

Cell[BoxData[
    \(43.199999999999985`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]3 = 216*0.500000000000000888`\)], "Input"],

Cell[BoxData[
    \(108.000000000000206`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]4 = 216*0.999999999999998046`\)], "Input"],

Cell[BoxData[
    \(215.99999999999957`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]5 = 216*1.64556191118563681`\)], "Input"],

Cell[BoxData[
    \(355.441372816097578`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\( (*\ Exact\ eigenvalues\ are\ given\ by\ \((n*\[Pi])\)^n\ *) \n
    \(exact\[Lambda][n_] := \ \((n*\[Pi])\)^2 // N; \)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(exact\[Lambda][1]\)], "Input"],

Cell[BoxData[
    \(9.86960440108935799`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(exact\[Lambda][2]\)], "Input"],

Cell[BoxData[
    \(39.4784176043574319`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(exact\[Lambda][3]\)], "Input"],

Cell[BoxData[
    \(88.8264396098042219`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(exact\[Lambda][4]\)], "Input"],

Cell[BoxData[
    \(157.913670417429718`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(exact\[Lambda][5]\)], "Input"],

Cell[BoxData[
    \(246.740110027233949`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ The\ above\ solution\ is\ given\ in\ Kantorovich\ and\ Krylov, \ 
      1958, \ p . \ 161. \n\tNow\ we\ shall\ do\ our\ own\ example\ 2.5  .1\ 
          with\ \n\t\tx1 = \(s1 = 1/10\), \ x2 = \(s2 = 3/10\), \ 
      x3 = \(s3 = 1/2\), \ x4 = \(s4 = 7/10\), \ 
      x5 = \(s5 = 9/10\ \ and\ denote\ the\ matrix\ denom\ by\ a\)\ , \n
      and\ we\ take\ \[Lambda] = 216\ x\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a = {\n
        \t{k[1/10, 1/10] - \ 216*x*k2[1/10, \ 1/10], \n\t\t\t
          k[1/10, 3/10] - \ 216*x*k2[1/10, \ 3/10], \n\t\t\t
          k[1/10, 1/2] - \ 216*x*k2[1/10, \ 1/2], \n\t\t\t
          k[1/10, 7/10] - \ 216*x*k2[1/10, \ 7/10], \n\t\t\t
          k[1/10, 9/10] - 216*x*k2[1/10, \ 9/10]}, \n
        \t{k[3/10, 1/10] - \ 216*x*k2[3/10, \ 1/10], \n\t\t\t
          k[3/10, 3/10] - \ 216*x*k2[3/10, \ 3/10], \n\t\t\t
          k[3/10, 1/2] - \ 216*x*k2[3/10, \ 1/2], \n\t\t\t
          k[3/10, 7/10] - \ 216*x*k2[3/10, \ 7/10], \n\t\t\t
          k[3/10, 9/10] - \ 216*x*k2[3/10, \ 9/10]}, \n
        \t\t{k[5/10, 1/10] - \ 216*x*k2[5/10, \ 1/10], \n\t\t\t
          k[5/10, 3/10] - \ 216*x*k2[5/10, \ 3/10], \n\t\t\t
          k[5/10, 1/2] - \ 216*x*k2[5/10, \ 1/2], \n\t\t\t
          k[5/10, 7/10] - \ 216*x*k2[5/10, \ 7/10], \n\t\t\t
          k[5/10, 9/10] - \ 216*x*k2[5/10, \ 9/10]}, \n
        \t\t\t{k[7/10, 1/10] - \ 216*x*k2[7/10, \ 1/10], \n\t\t\t
          k[7/10, 3/10] - \ 216*x*k2[7/10, \ 3/10], \n\t\t\t
          k[7/10, 1/2] - 216*x*k2[7/10, \ 1/2], \n\t\t\t
          k[7/10, 7/10] - \ 216*x*k2[7/10, \ 7/10], \n\t\t\t
          k[7/10, 9/10] - \ 216*x*k2[7/10, \ 9/10]}, \t\n
        \t\t\t\t{k[9/10, 1/10] - \ 216*x*k2[9/10, \ 1/10], \n\t\t\t
          k[9/10, 3/10] - \ 216*x*k2[9/10, \ 3/10], \n\t\t\t
          k[9/10, 1/2] - \ 216*x*k2[9/10, \ 1/2], \n\t\t\t
          k[9/10, 7/10] - \ 216*x*k2[9/10, \ 7/10], \n\t\t\t
          k[9/10, 9/10] - \ 216*x*k2[9/10, \ 9/10]}\ \ }\)], "Input"],

Cell[BoxData[
    \({{9\/100 - \(729\ x\)\/1250, 7\/100 - \(63\ x\)\/50, 
        1\/20 - \(333\ x\)\/250, 3\/100 - \(243\ x\)\/250, 
        1\/100 - \(441\ x\)\/1250}, {\(-\(7\/100\)\) - \(63\ x\)\/50, 
        21\/100 - \(3969\ x\)\/1250, 3\/20 - \(891\ x\)\/250, 
        9\/100 - \(3321\ x\)\/1250, 3\/100 - \(243\ x\)\/250}, {
        \(-\(1\/20\)\) - \(333\ x\)\/250, \(-\(3\/20\)\) - \(891\ x\)\/250, 
        1\/4 - \(9\ x\)\/2, 3\/20 - \(891\ x\)\/250, 
        1\/20 - \(333\ x\)\/250}, {\(-\(3\/100\)\) - \(243\ x\)\/250, 
        \(-\(9\/100\)\) - \(3321\ x\)\/1250, 
        \(-\(3\/20\)\) - \(891\ x\)\/250, 21\/100 - \(3969\ x\)\/1250, 
        7\/100 - \(63\ x\)\/50}, {\(-\(1\/100\)\) - \(441\ x\)\/1250, 
        \(-\(3\/100\)\) - \(243\ x\)\/250, \(-\(1\/20\)\) - \(333\ x\)\/250, 
        \(-\(7\/100\)\) - \(63\ x\)\/50, 9\/100 - \(729\ x\)\/1250}}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[%]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(9\/100 - \(729\ x\)\/1250\), \(7\/100 - \(63\ x\)\/50\), 
              \(1\/20 - \(333\ x\)\/250\), \(3\/100 - \(243\ x\)\/250\), 
              \(1\/100 - \(441\ x\)\/1250\)},
            {\(\(-\(7\/100\)\) - \(63\ x\)\/50\), 
              \(21\/100 - \(3969\ x\)\/1250\), \(3\/20 - \(891\ x\)\/250\), 
              \(9\/100 - \(3321\ x\)\/1250\), \(3\/100 - \(243\ x\)\/250\)},
            {\(\(-\(1\/20\)\) - \(333\ x\)\/250\), 
              \(\(-\(3\/20\)\) - \(891\ x\)\/250\), \(1\/4 - \(9\ x\)\/2\), 
              \(3\/20 - \(891\ x\)\/250\), \(1\/20 - \(333\ x\)\/250\)},
            {\(\(-\(3\/100\)\) - \(243\ x\)\/250\), 
              \(\(-\(9\/100\)\) - \(3321\ x\)\/1250\), 
              \(\(-\(3\/20\)\) - \(891\ x\)\/250\), 
              \(21\/100 - \(3969\ x\)\/1250\), \(7\/100 - \(63\ x\)\/50\)},
            {\(\(-\(1\/100\)\) - \(441\ x\)\/1250\), 
              \(\(-\(3\/100\)\) - \(243\ x\)\/250\), 
              \(\(-\(1\/20\)\) - \(333\ x\)\/250\), 
              \(\(-\(7\/100\)\) - \(63\ x\)\/50\), 
              \(9\/100 - \(729\ x\)\/1250\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[Det[a]\  == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0359830249575348126`}, {
        x \[Rule] 0.325473907956130048`}, {x \[Rule] 1.06494875897398499`}, {
        x \[Rule] 2.39498674144363876`}, {x \[Rule] 4.67275961345233703`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]1 = 216*0.0359830249575348126`\)], "Input"],

Cell[BoxData[
    \(7.77233339082751939`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]2 = 216*0.325473907956130048`\)], "Input"],

Cell[BoxData[
    \(70.3023641185240943`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]3 = 216*1.06494875897398499`\)], "Input"],

Cell[BoxData[
    \(230.028931938380765`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]4 = 216*2.39498674144363876`\)], "Input"],

Cell[BoxData[
    \(517.317136151825884`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]5 = 216*4.67275961345233703`\)], "Input"],

Cell[BoxData[
    \(1009.31607650570476`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ We\ choose\ different\ x_i\ and\ s_j, \ 
      to\ avoid\ the\ singularity\ at\ x = s\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(denom = {\n
        \t{k[1/7, 1/6] - \ 216*x*k2[1/7, \ 1/6], \n\t\t\t
          k[1/7, 1/3] - \ 216*x*k2[1/7, \ 1/3], \n\t\t\t
          k[1/7, 1/2] - \ 216*x*k2[1/7, \ 1/2], \n\t\t\t
          k[1/7, 2/3] - \ 216*x*k2[1/7, \ 2/3], \n\t\t\t
          k[1/7, 5/6] - \ 216*x*k2[1/7, \ 5/6]}, \n
        \t{k[2/7, 1/6] - \ 216*x*k2[2/7, \ 1/6], \n\t\t\t
          k[2/7, 1/3] - \ 216*x*k2[2/7, \ 1/3], \n\t\t\t
          k[2/7, 1/2] - \ 216*x*k2[2/7, \ 1/2], \n\t\t\t
          k[2/7, 2/3] - \ 216*x*k2[2/7, \ 2/3], \n\t\t\t
          k[2/7, 5/6] - \ 216*x*k2[2/7, \ 5/6]}, \n
        \t\t{k[3/7, 1/6] - \ 216*x*k2[3/7, \ 1/6], \n\t\t\t
          k[3/7, 1/3] - \ 216*x*k2[3/7, \ 1/3], \n\t\t\t
          k[3/7, 1/2] - \ 216*x*k2[3/7, \ 1/2], \n\t\t\t
          k[3/7, 2/3] - \ 216*x*k2[3/7, \ 2/3], \n\t\t\t
          k[3/7, 5/6] - \ 216*x*k2[3/7, \ 5/6]}, \n
        \t\t{k[4/7, 1/6] - \ 216*x*k2[4/7, \ 1/6], \n\t\t\t
          k[4/7, 1/3] - \ 216*x*k2[4/7, \ 1/3], \n\t\t\t
          k[4/7, 1/2] - \ 216*x*k2[4/7, \ 1/2], \n\t\t\t
          k[4/7, 2/3] - \ 216*x*k2[4/7, \ 2/3], \n\t\t\t
          k[4/7, 5/6] - \ 216*x*k2[4/7, \ 5/6]}, \t\n
        \t\t\t{k[5/7, 1/6] - \ 216*x*k2[5/7, \ 1/6], \n\t\t\t
          k[5/7, 1/3] - \ 216*x*k2[5/7, \ 1/3], \n\t\t\t
          k[5/7, 1/2] - \ 216*x*k2[5/7, \ 1/2], \n\t\t\t
          k[5/7, 2/3] - \ 216*x*k2[5/7, \ 2/3], \n\t\t\t
          k[5/7, 5/6] - \ 216*x*k2[5/7, \ 5/6]}\ \ }\)], "Input"],

Cell[BoxData[
    \({{5\/42 - \(2515\ x\)\/2058, 2\/21 - \(1888\ x\)\/1029, 
        1\/14 - \(1287\ x\)\/686, 1\/21 - \(1532\ x\)\/1029, 
        1\/42 - \(1679\ x\)\/2058}, {\(-\(5\/42\)\) - \(4075\ x\)\/2058, 
        4\/21 - \(3344\ x\)\/1029, 1\/7 - \(1179\ x\)\/343, 
        2\/21 - \(2848\ x\)\/1029, 1\/21 - \(1571\ x\)\/1029}, {
        \(-\(2\/21\)\) - \(2278\ x\)\/1029, 
        \(-\(4\/21\)\) - \(3968\ x\)\/1029, 3\/14 - \(2997\ x\)\/686, 
        1\/7 - \(1244\ x\)\/343, 1\/14 - \(1391\ x\)\/686}, {
        \(-\(1\/14\)\) - \(1391\ x\)\/686, \(-\(1\/7\)\) - \(1244\ x\)\/343, 
        \(-\(3\/14\)\) - \(2997\ x\)\/686, 4\/21 - \(3968\ x\)\/1029, 
        2\/21 - \(2278\ x\)\/1029}, {\(-\(1\/21\)\) - \(1571\ x\)\/1029, 
        \(-\(2\/21\)\) - \(2848\ x\)\/1029, \(-\(1\/7\)\) - \(1179\ x\)\/343, 
        \(-\(4\/21\)\) - \(3344\ x\)\/1029, 5\/42 - \(4075\ x\)\/2058}}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[%]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(5\/42 - \(2515\ x\)\/2058\), \(2\/21 - \(1888\ x\)\/1029\), 
              \(1\/14 - \(1287\ x\)\/686\), \(1\/21 - \(1532\ x\)\/1029\), 
              \(1\/42 - \(1679\ x\)\/2058\)},
            {\(\(-\(5\/42\)\) - \(4075\ x\)\/2058\), 
              \(4\/21 - \(3344\ x\)\/1029\), \(1\/7 - \(1179\ x\)\/343\), 
              \(2\/21 - \(2848\ x\)\/1029\), \(1\/21 - \(1571\ x\)\/1029\)},
            {\(\(-\(2\/21\)\) - \(2278\ x\)\/1029\), 
              \(\(-\(4\/21\)\) - \(3968\ x\)\/1029\), 
              \(3\/14 - \(2997\ x\)\/686\), \(1\/7 - \(1244\ x\)\/343\), 
              \(1\/14 - \(1391\ x\)\/686\)},
            {\(\(-\(1\/14\)\) - \(1391\ x\)\/686\), 
              \(\(-\(1\/7\)\) - \(1244\ x\)\/343\), 
              \(\(-\(3\/14\)\) - \(2997\ x\)\/686\), 
              \(4\/21 - \(3968\ x\)\/1029\), \(2\/21 - \(2278\ x\)\/1029\)},
            {\(\(-\(1\/21\)\) - \(1571\ x\)\/1029\), 
              \(\(-\(2\/21\)\) - \(2848\ x\)\/1029\), 
              \(\(-\(1\/7\)\) - \(1179\ x\)\/343\), 
              \(\(-\(4\/21\)\) - \(3344\ x\)\/1029\), 
              \(5\/42 - \(4075\ x\)\/2058\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[Det[denom] == 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0325800169864255284`}, {
        x \[Rule] 0.406971325392484217`}, {x \[Rule] 1.75851834210615347`}, {
        x \[Rule] 5.17328455862867198`}, {x \[Rule] 12.2212634812613596`}}
      \)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ Eigenvalues\ are\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]1 = 216*0.0325800169864255284`\)], "Input"],

Cell[BoxData[
    \(7.03728366906791436`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]2 = 216*0.406971325392484217`\)], "Input"],

Cell[BoxData[
    \(87.9058062847765953`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]3 = 216*1.75851834210615347`\)], "Input"],

Cell[BoxData[
    \(379.839961894929123`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]4 = 216*5.17328455862867198`\)], "Input"],

Cell[BoxData[
    \(1117.42946466379322`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]5 = 216*12.2212634812613596`\)], "Input"],

Cell[BoxData[
    \(2639.79291195245391`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{527, 496},
WindowMargins->{{73, Automatic}, {Automatic, 3}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 196, 3, 59, "Input"],
Cell[1908, 54, 274, 5, 59, "Input"],

Cell[CellGroupData[{
Cell[2207, 63, 1460, 26, 427, "Input"],
Cell[3670, 91, 768, 11, 178, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4475, 107, 46, 1, 27, "Input"],
Cell[4524, 110, 1097, 21, 133, "Output"]
}, Open  ]],
Cell[5636, 134, 143, 3, 43, "Input"],

Cell[CellGroupData[{
Cell[5804, 141, 672, 11, 171, "Input"],
Cell[6479, 154, 598, 9, 86, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7114, 168, 46, 1, 27, "Input"],
Cell[7163, 171, 885, 17, 88, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8085, 193, 57, 1, 27, "Input"],
Cell[8145, 196, 234, 4, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8416, 205, 114, 2, 43, "Input"],
Cell[8533, 209, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8624, 215, 71, 1, 27, "Input"],
Cell[8698, 218, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8788, 224, 71, 1, 27, "Input"],
Cell[8862, 227, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8953, 233, 71, 1, 27, "Input"],
Cell[9027, 236, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9117, 242, 70, 1, 27, "Input"],
Cell[9190, 245, 54, 1, 26, "Output"]
}, Open  ]],
Cell[9259, 249, 155, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[9439, 255, 50, 1, 27, "Input"],
Cell[9492, 258, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9583, 264, 50, 1, 27, "Input"],
Cell[9636, 267, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9727, 273, 50, 1, 27, "Input"],
Cell[9780, 276, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9871, 282, 50, 1, 27, "Input"],
Cell[9924, 285, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10015, 291, 50, 1, 27, "Input"],
Cell[10068, 294, 54, 1, 26, "Output"]
}, Open  ]],
Cell[10137, 298, 418, 6, 107, "Input"],

Cell[CellGroupData[{
Cell[10580, 308, 1546, 26, 427, "Input"],
Cell[12129, 336, 887, 14, 246, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13053, 355, 46, 1, 27, "Input"],
Cell[13102, 358, 1210, 22, 145, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14349, 385, 61, 1, 27, "Input"],
Cell[14413, 388, 232, 4, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14682, 397, 72, 1, 27, "Input"],
Cell[14757, 400, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14848, 406, 71, 1, 27, "Input"],
Cell[14922, 409, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15013, 415, 70, 1, 27, "Input"],
Cell[15086, 418, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15177, 424, 70, 1, 27, "Input"],
Cell[15250, 427, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15341, 433, 70, 1, 27, "Input"],
Cell[15414, 436, 54, 1, 26, "Output"]
}, Open  ]],
Cell[15483, 440, 130, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[15638, 446, 1460, 26, 427, "Input"],
Cell[17101, 474, 907, 14, 246, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18045, 493, 46, 1, 27, "Input"],
Cell[18094, 496, 1245, 23, 145, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19376, 524, 61, 1, 27, "Input"],
Cell[19440, 527, 232, 4, 41, "Output"]
}, Open  ]],
Cell[19687, 534, 59, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[19771, 539, 72, 1, 27, "Input"],
Cell[19846, 542, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19937, 548, 71, 1, 27, "Input"],
Cell[20011, 551, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20102, 557, 70, 1, 27, "Input"],
Cell[20175, 560, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20266, 566, 70, 1, 27, "Input"],
Cell[20339, 569, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20430, 575, 70, 1, 27, "Input"],
Cell[20503, 578, 54, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

